package edu.columbia.cs.itx.dsadmin;

import java.awt.*;
import java.awt.event.*;
import java.util.*;
import javax.swing.*;
import javax.swing.table.*;
import cnrg.itx.ds.*;
import edu.columbia.cs.itx.dsadmin.event.*;

public class DSAuthenticator extends AbstractDSAuthenticationModel implements ActionListener {
  private DirectoryService ds;
  private LoginDialog loginDialog;
  private UserID adminID;
  private Password adminPass;
  private Frame parent;
  private boolean authenticated = false;
  private TableModel sorter;
  private TableModel usersTableModel;

  public DSAuthenticator(Frame parent, JTable usersTable, DirectoryService ds) throws DSAuthenticatorException {
    if (ds == null)
      throw new DSAuthenticatorException("Directory service not initialized.");

    this.ds = ds;
    this.parent = parent;
    loginDialog = new LoginDialog(parent, "Administrator's Login", false);
    loginDialog.setFieldListener(this);
    loginDialog.setSubmitListener(this);
    loginDialog.setVisible(true);

    sorter = usersTable.getModel();
    usersTableModel = ((TableMap)sorter).getModel();
  }

  public DirectoryService getDS() {
    return ds;
  }

  public void authenticate() {
    authenticated = false;
    loginDialog.hide();
    adminID = new UserID(loginDialog.getID());
    adminPass = new Password(loginDialog.getPass());
    try {
      ds.declareIdentity(adminID, adminPass);
      if (ds.getAccessLevel() != DirectoryService.ADM_ACCESS_LEVEL) {
        warning("You are not an administrator.\nPlease login with an administrator's ID.");
      }
      else {
        authenticated = true;
        fireAuthenticated(this);
        dataUpdated();
      }
    } catch (AuthenticationException exp1) {
      warning("Authentication fails.\nPlease try again.");
    }
    loginDialog.dispose();
    loginDialog = null;
  }

  // listen to the login button and fields
  public void actionPerformed(ActionEvent e) {
    authenticate();
  }

  private void warning(String msg) {
    JOptionPane.showMessageDialog(parent, msg, "Warning", JOptionPane.WARNING_MESSAGE);
  }

  public boolean isAuthenticated() {
    return authenticated;
  }

  // finish login
  public boolean isFinished() {
    return loginDialog == null;
  }

  // called when authenticated, from authenticate()
  public void dataUpdated() {
    try {
      Vector users = ds.dumpAllUsers();
      ((DSTableModel)usersTableModel).setUsers(users);
    } catch (Exception e) {
      e.printStackTrace();
    }
  }
}

